using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using Microsoft.DirectX.DirectPlay;

using DarkStrideToolbox;


namespace DarkStride.StellarLanes.Server
{
	public class frmStartServer : System.Windows.Forms.Form
	{
		#region Properties
		//private DSNetworkWrapper m_oGameEngine.DirectPlay = null;
		private int m_nPort = 0;
		private string m_sServiceProviderGUID = "";
		private string m_sServerName = "";
		#endregion
        
		#region System Stuff
		private System.Windows.Forms.ImageList imgIcons;
		private System.Windows.Forms.Button cmdCancel;
		private System.Windows.Forms.Button cmdStart;
		private System.Windows.Forms.TextBox txtPort;
		private System.Windows.Forms.Label lblPublicIP;
		private System.Windows.Forms.TextBox txtPublicIP;
		private System.Windows.Forms.ListBox lstServiceProviders;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label lblPort;
		private System.Windows.Forms.Label lblName;
		private System.Windows.Forms.TextBox txtServerName;
		private System.ComponentModel.IContainer components;

		public frmStartServer()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(frmStartServer));
			this.imgIcons = new System.Windows.Forms.ImageList(this.components);
			this.txtPort = new System.Windows.Forms.TextBox();
			this.lblPublicIP = new System.Windows.Forms.Label();
			this.txtPublicIP = new System.Windows.Forms.TextBox();
			this.cmdCancel = new System.Windows.Forms.Button();
			this.cmdStart = new System.Windows.Forms.Button();
			this.lstServiceProviders = new System.Windows.Forms.ListBox();
			this.label2 = new System.Windows.Forms.Label();
			this.lblPort = new System.Windows.Forms.Label();
			this.txtServerName = new System.Windows.Forms.TextBox();
			this.lblName = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// imgIcons
			// 
			this.imgIcons.ImageSize = new System.Drawing.Size(16, 16);
			this.imgIcons.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imgIcons.ImageStream")));
			this.imgIcons.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// txtPort
			// 
			this.txtPort.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.txtPort.Location = new System.Drawing.Point(64, 32);
			this.txtPort.Name = "txtPort";
			this.txtPort.Size = new System.Drawing.Size(72, 20);
			this.txtPort.TabIndex = 0;
			this.txtPort.Text = "";
			// 
			// lblPublicIP
			// 
			this.lblPublicIP.Location = new System.Drawing.Point(8, 56);
			this.lblPublicIP.Name = "lblPublicIP";
			this.lblPublicIP.Size = new System.Drawing.Size(56, 16);
			this.lblPublicIP.TabIndex = 3;
			this.lblPublicIP.Text = "Public IP:";
			this.lblPublicIP.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// txtPublicIP
			// 
			this.txtPublicIP.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.txtPublicIP.Enabled = false;
			this.txtPublicIP.Location = new System.Drawing.Point(64, 56);
			this.txtPublicIP.Name = "txtPublicIP";
			this.txtPublicIP.Size = new System.Drawing.Size(104, 20);
			this.txtPublicIP.TabIndex = 2;
			this.txtPublicIP.Text = "";
			// 
			// cmdCancel
			// 
			this.cmdCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.cmdCancel.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.cmdCancel.ImageAlign = System.Drawing.ContentAlignment.BottomLeft;
			this.cmdCancel.ImageIndex = 0;
			this.cmdCancel.ImageList = this.imgIcons;
			this.cmdCancel.Location = new System.Drawing.Point(8, 148);
			this.cmdCancel.Name = "cmdCancel";
			this.cmdCancel.Size = new System.Drawing.Size(72, 24);
			this.cmdCancel.TabIndex = 9;
			this.cmdCancel.Text = "     &Cancel";
			this.cmdCancel.Click += new System.EventHandler(this.cmdCancel_Click);
			// 
			// cmdStart
			// 
			this.cmdStart.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdStart.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.cmdStart.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.cmdStart.ImageIndex = 1;
			this.cmdStart.ImageList = this.imgIcons;
			this.cmdStart.Location = new System.Drawing.Point(220, 148);
			this.cmdStart.Name = "cmdStart";
			this.cmdStart.Size = new System.Drawing.Size(72, 24);
			this.cmdStart.TabIndex = 8;
			this.cmdStart.Text = "    &Start";
			this.cmdStart.Click += new System.EventHandler(this.cmdStart_Click);
			// 
			// lstServiceProviders
			// 
			this.lstServiceProviders.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lstServiceProviders.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lstServiceProviders.Location = new System.Drawing.Point(64, 80);
			this.lstServiceProviders.Name = "lstServiceProviders";
			this.lstServiceProviders.Size = new System.Drawing.Size(224, 54);
			this.lstServiceProviders.TabIndex = 10;
			this.lstServiceProviders.SelectedIndexChanged += new System.EventHandler(this.lstServiceProviders_SelectedIndexChanged);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 80);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(56, 16);
			this.label2.TabIndex = 12;
			this.label2.Text = "Public IP:";
			// 
			// lblPort
			// 
			this.lblPort.Location = new System.Drawing.Point(8, 32);
			this.lblPort.Name = "lblPort";
			this.lblPort.Size = new System.Drawing.Size(56, 16);
			this.lblPort.TabIndex = 13;
			this.lblPort.Text = "Port:";
			this.lblPort.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// txtServerName
			// 
			this.txtServerName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtServerName.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.txtServerName.Location = new System.Drawing.Point(64, 8);
			this.txtServerName.Name = "txtServerName";
			this.txtServerName.Size = new System.Drawing.Size(224, 20);
			this.txtServerName.TabIndex = 14;
			this.txtServerName.Text = "";
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(8, 8);
			this.lblName.Name = "lblName";
			this.lblName.Size = new System.Drawing.Size(56, 16);
			this.lblName.TabIndex = 15;
			this.lblName.Text = "Name:";
			this.lblName.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// frmStartServer
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(296, 181);
			this.ControlBox = false;
			this.Controls.Add(this.txtServerName);
			this.Controls.Add(this.txtPublicIP);
			this.Controls.Add(this.txtPort);
			this.Controls.Add(this.lblName);
			this.Controls.Add(this.lblPort);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.lstServiceProviders);
			this.Controls.Add(this.cmdCancel);
			this.Controls.Add(this.cmdStart);
			this.Controls.Add(this.lblPublicIP);
			this.Name = "frmStartServer";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Start App Server";
			this.Load += new System.EventHandler(this.frmStart_Load);
			this.ResumeLayout(false);

		}
		#endregion
		#endregion


		private void frmStart_Load(object sender, System.EventArgs e)
		{
			//int nIndex = 0;


			//Default stuff
			txtPort.Text = m_nPort.ToString();
			txtPublicIP.Text = DSMisc.GetMyIP();
			txtServerName.Text = m_sServerName;

			/*//Load the service providers
			foreach( ServiceProviderInformation oSPInfo in m_oGameEngine.DirectPlay.GetServiceProviders() )
			{
				nIndex = lstServiceProviders.Items.Add( oSPInfo );

				if( oSPInfo.Guid.ToString() == m_sServiceProviderGUID )
				{
					lstServiceProviders.SelectedIndex = nIndex;
				}
			}*/

			//cmdStart_Click( null,null );
		}


		private void cmdStart_Click(object sender, System.EventArgs e)
		{
			//ServiceProviderInformation oSPInfo;


			//Save the port
			if( DSMisc.IsNumericLong( txtPort.Text ) == true )
			{
				m_nPort = Convert.ToInt32( txtPort.Text );
			}
			else
			{
				MessageBox.Show( "Please enter a valid port number." );
				return;
			}

			//Save the name
			if( txtServerName.Text.Length > 0 )
			{
				m_sServerName = txtServerName.Text;
			}
			else
			{
				MessageBox.Show( "Please enter a valid server name." );
				return;
			}

			//Save the service provider
			/*oSPInfo = (ServiceProviderInformation)lstServiceProviders.SelectedItem;
			m_sServiceProviderGUID = oSPInfo.Guid.ToString();*/

			//Tell them we said yes
			this.DialogResult = System.Windows.Forms.DialogResult.Yes;
		}
		private void cmdCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = System.Windows.Forms.DialogResult.No;
		}

		private void lstServiceProviders_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			cmdStart.Enabled = ( lstServiceProviders.SelectedItem != null );
		}



		#region Properties
		/*public DSNetworkWrapper DSNetworkWrapper
		{
			get
			{
				return( m_oGameEngine.DirectPlay );
			}
			set
			{
				m_oGameEngine.DirectPlay = value;
			}
		}*/
		public string ServiceProviderGUID
		{
			get
			{
				return( m_sServiceProviderGUID );
			}
			set
			{
				m_sServiceProviderGUID = value;
			}
		}
		public int Port
		{
			get
			{
				return( m_nPort );
			}
			set
			{
				m_nPort = value;
			}
		}
		public string ServerName
		{
			get
			{
				return( m_sServerName );
			}
			set
			{
				m_sServerName = value;
			}
		}
		#endregion
	}
}
